//
//  ViewController.m
//  RoadTripBingo
//
//  Created by Juan Navas Martin on 2/15/14.
//  Copyright (c) 2014 Juan Navas. All rights reserved.
//

#import "ViewController.h"

@interface ViewController (){
    RTBGame *game;
    NSMutableArray *gameSigns, *savedGames;
    NSArray *topScores;
}

@end

@implementation ViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
	// Do any additional setup after loading the view, typically from a nib.
}

- (void)viewWillAppear:(BOOL)animated {
    [self.navigationController setNavigationBarHidden:YES];
    
    RTBGameDAO *dao = [[RTBGameDAO alloc]init];
    game = [dao getCurrentGame];
    //NSLog(@"Game: %@", game);
    dao = nil;
    
    //NSLog(@"Game: %@", game);
}
- (void)viewWillDisappear:(BOOL)animated {
    //[self.navigationController setNavigationBarHidden:NO];
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (IBAction)startNewGame:(id)sender {
    
    [self.playerName resignFirstResponder];
    
    if ([self.playerName.text isEqualToString:@""]) {
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"Player Name Required" message:Nil delegate:self cancelButtonTitle:@"Ok" otherButtonTitles:nil, nil];
        alert.tag = kAlertViewOne;
        [alert show];
    }
    else {
//        if (game) {
//            UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"Start new game?" message:@"Previous saved game will be dismissed" delegate:self cancelButtonTitle:@"Cancel" otherButtonTitles:@"Ok", nil];
//            alert.tag = kAlertViewTwo;
//            [alert show];
//        }
//        else {
            [self createNewGame];
//        }
    }
}

- (IBAction)resumeGame:(id)sender {
    [self.playerName resignFirstResponder];
    
//    if (game) {
//        GameDetailsDAO *dao = [[GameDetailsDAO alloc]init];
//        if (gameSigns) {
//            gameSigns = [[NSMutableArray alloc]init];
//        }
//        
//        gameSigns = [dao getCurrentTrafficSigns:game.gameID];
//        NSLog(@"\nCURRENT GAME: %@", game);
//        
//        [self performSegueWithIdentifier:@"startGame" sender:sender];
//    }
//    else {
//        UIAlertView *alert = [[UIAlertView alloc]initWithTitle:@"No active games" message:nil delegate:self cancelButtonTitle:@"Ok" otherButtonTitles:nil];
//        [alert show];
//    }
    
    RTBGameDAO *dao = [[RTBGameDAO alloc]init];
    //savedGames = [[dao getSavedGames] copy];
    savedGames = [dao getSavedGames];
    dao = nil;
    
//    NSLog(@"SAVED GAMES ##############");
//    for (RTBGame *g in savedGames) {
//        NSLog(@"%@", g);
//    }
//    NSLog(@"\nCURRENT SIGNS: %@", savedGames);
    
    if ([savedGames count] > 0) {
        [self performSegueWithIdentifier:@"showSavedGames" sender:sender];
    }
    else {
        UIAlertView *alert = [[UIAlertView alloc]initWithTitle:@"No active games" message:nil delegate:self cancelButtonTitle:@"Ok" otherButtonTitles:nil];
        [alert show];
    }
}

- (IBAction)topScores:(id)sender {
    
    RTBGameDAO *dao = [[RTBGameDAO alloc]init];
    topScores = [[dao getFinishedGames] copy];
    dao = Nil;
    
    [self performSegueWithIdentifier:@"showTopScores" sender:sender];
}


//When user touches any white space in the screen
//it makes all the controls to loose focus
-(void)touchesBegan:(NSSet *)touches withEvent:(UIEvent *)event {
    [self.view endEditing:YES];
}

- (BOOL)textFieldShouldReturn:(UITextField *)textField {
    [textField resignFirstResponder];
    return NO;
}

- (void)alertView:(UIAlertView *)alertView didDismissWithButtonIndex:(NSInteger)buttonIndex
{
    //NSLog(@"Button Index =%ld",buttonIndex);
    if (buttonIndex == 0)
    {
        NSLog(@"You have clicked Cancel");
    }
    else if ((buttonIndex == 1) && (alertView.tag == kAlertViewTwo))
    {
        //Close previous games
//        RTBGameDAO *dao = [[RTBGameDAO alloc]init];
//        
//        game.endDate = [NSDate date];
//        game.gotBingo = NO;
//        
//        [dao saveCurrentGame:game];
//        game = Nil;
//        
//        [self createNewGame];
    }
}

- (void)createNewGame{
    
    //CREATE GAME OBJECT
    game = [[RTBGame alloc] init];
    game.playerName = self.playerName.text;
    self.playerName.text = @"";
    game.startDate = [NSDate date];
    game.gotBingo = NO;
    
    //Save Game to SQLite
    RTBGameDAO *dao = [[RTBGameDAO alloc]init];
    game.gameID = (int)[dao createGame:game];
    
    NSLog(@"Game created with id: %d", game.gameID);
    
    //Generate Bingo Array
    if (gameSigns) {
        gameSigns = Nil;
    }
    [self generateBingoArray];
    
    //TODO: Save Game Details (Bingo Array) to Game
    GameDetailsDAO *daoDetails = [[GameDetailsDAO alloc]init];
    [daoDetails saveGameDetails: gameSigns];
    
    //TODO: Segue to New VC
    [self performSegueWithIdentifier:@"startGame" sender:self];
}

- (void) generateBingoArray {
    // get paths from root directory
    NSArray *paths = NSSearchPathForDirectoriesInDomains (NSDocumentDirectory, NSUserDomainMask, YES);
    // get documents path
    NSString *documentsPath = [paths objectAtIndex:0];
    // get the path to our Data/plist file
    NSString *plistPath = [documentsPath stringByAppendingPathComponent:@"TrafficSigns.plist"];
    
    // check to see if Data.plist exists in documents
    if (![[NSFileManager defaultManager] fileExistsAtPath:plistPath])
    {
        // if not in documents, get property list from main bundle
        plistPath = [[NSBundle mainBundle] pathForResource:@"TrafficSigns" ofType:@"plist"];
    }
    
    NSDictionary *totalDictionary = [NSDictionary dictionaryWithContentsOfFile:plistPath];
    NSLog(@"Plist Content%@",totalDictionary);
    
    NSMutableArray *totalArray = [NSMutableArray arrayWithArray:[totalDictionary allKeys]];
    unsigned short count = (unsigned short)[totalArray count];
    
    for (unsigned short i = 0; i < count; ++i) {
        unsigned short nElements = count - i;
        unsigned short n = (arc4random() % nElements) + i;
        [totalArray exchangeObjectAtIndex:i withObjectAtIndex:n];
    }
    
    gameSigns = [[NSMutableArray alloc]init];
    
    for (unsigned short i=0; i < 25; i++){
        
        RTBSign *sign = [[RTBSign alloc]init];
        sign.gameID = game.gameID;
        sign.position = i;
        sign.name = [totalDictionary objectForKey:[totalArray objectAtIndex:i]];
        sign.defaultImageUrl = [totalArray objectAtIndex:i];
        sign.hasBeenConfirmed = NO;
        
        [gameSigns addObject:sign];
    }
    NSLog(@"Game Traffic Signs Array: %@", gameSigns);
}

#pragma mark - Navigation
-(void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    
    if([segue.identifier isEqualToString:@"startGame"]){
        
        GameBoardViewController *gbvc = [segue destinationViewController];
        gbvc.currentGame = game;
        gbvc.tSigns = gameSigns;
    }
    else if([segue.identifier isEqualToString:@"showTopScores"]){
        
        TopScoresViewController *tsvc = [segue destinationViewController];
        tsvc.topScores = topScores;
    }
    else if([segue.identifier isEqualToString:@"showSavedGames"]){
        
        ResumeGamesViewController *rgvc = [segue destinationViewController];
        rgvc.savedGames = savedGames;
    }
}



@end
